

#ifndef BLP2DECODE_H
#define BLP2DECODE_H

#ifndef BLP2DECODE_STATIC
	#ifdef BLP2DECODE_EXPORTS
	#define BLP2DECODE_API __declspec(dllexport)
	#else
	#define BLP2DECODE_API __declspec(dllimport)
	#endif
#else
#define BLP2DECODE_API
#endif
typedef struct
{
	char ident[4];
	unsigned long type;
	char flags[4];
	unsigned long width;
	unsigned long height;
	unsigned long mipmapoffsets[16];
	unsigned long mipmaplengths[16];
} blp2header;

typedef struct 
{
	char ident[4];
	int type;
	int alpha;
	int width;
	int height;
	int mipmapoffsets[16];
	int mipmaplengths[16];
} blp1header;

typedef struct 
{
	unsigned char r,g,b,a;
} rgba;

typedef rgba palette[256];

BLP2DECODE_API void BLP2DECODE_GetLastErrorStr(char* outstr);
//Gets string regarding the last error
BLP2DECODE_API unsigned long BLP2DECODE_GetLastError();
//Returns the error number of the last error
BLP2DECODE_API unsigned char* BLP2DECODE_BLP2toRGBA(blp2header *b, unsigned char* in, unsigned long insize, unsigned long *outsize, palette p, unsigned long width, unsigned long height);
//Converts BLP2 data into RGBA data and returns a pointer to the data
BLP2DECODE_API unsigned char* BLP2DECODE_RGBAtoBLP2(unsigned char* in, unsigned long insize, blp2header *b2h, unsigned long width, unsigned long height, unsigned long* outsize);
//Converts RGBA data into BLP2 data and returns a pointer to the data

BLP2DECODE_API void BLP2DECODE_FreeAll();
//Frees error string and data variables from memory
BLP2DECODE_API void BLP2DECODE_FreeData();
//Frees data variable from memory
BLP2DECODE_API void BLP2DECODE_FreeErrorStr();
//Frees error string variable from memory

BLP2DECODE_API void BLP2DECODE_FreeBuffer();  
//Depreciated, still maintained for backwards compatability. Use BLP2DECODE_FreeData() instead.


//BLP2DECODE error codes.
/*
	"Unknown error!\0",														//0
	"Input buffer is NULL!\0",												//1
	"Invalid input buffer length specified!\0",								//2
	"BLP2 header specified is NULL!\0",										//3
	"Specified width is 0!\0",												//4
	"Specified height is 0!\0",												//5
	"BLP2 header flags not recgonized!\0",									//6
	"BLP2 type not supported!\0",											//7
	"Error compressing to DXT1 format!\0",									//8
	"Error decompressing from DXT5 format!\0",								//9
	"Error decompressing from DXT3 format!\0",								//10
	"Error decompressing from DXT1 format!\0"								//11
	"Error Compressing DXT1 format; length and width are not equal"			//12
*/
#endif