using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace WOWMapCreatorUT
{
	/// <summary>
	/// Summary description for ImageCropperUC.
	/// </summary>
	public class ImageCropperUC : System.Windows.Forms.UserControl
	{
		private System.Windows.Forms.Button btnLeftRight;
		private WOWMapCreatorUT.PictureBoxEx pictureBox1;
		private System.Windows.Forms.Button btnBottomUp;
		private System.Windows.Forms.Button btnTopUp;
		private System.Windows.Forms.Button btnBottomDown;
		private System.Windows.Forms.Button btnTopDown;
		private System.Windows.Forms.Button btnLeftLeft;
		private System.Windows.Forms.Button btnRightLeft;
		private System.Windows.Forms.Button btnRightRight;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ImageCropperUC()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ImageCropperUC));
			this.btnBottomUp = new System.Windows.Forms.Button();
			this.btnLeftRight = new System.Windows.Forms.Button();
			this.pictureBox1 = new WOWMapCreatorUT.PictureBoxEx();
			this.btnTopUp = new System.Windows.Forms.Button();
			this.btnBottomDown = new System.Windows.Forms.Button();
			this.btnTopDown = new System.Windows.Forms.Button();
			this.btnLeftLeft = new System.Windows.Forms.Button();
			this.btnRightLeft = new System.Windows.Forms.Button();
			this.btnRightRight = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// btnBottomUp
			// 
			this.btnBottomUp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.btnBottomUp.Image = ((System.Drawing.Image)(resources.GetObject("btnBottomUp.Image")));
			this.btnBottomUp.ImageAlign = System.Drawing.ContentAlignment.BottomCenter;
			this.btnBottomUp.Location = new System.Drawing.Point(32, 512);
			this.btnBottomUp.Name = "btnBottomUp";
			this.btnBottomUp.Size = new System.Drawing.Size(512, 16);
			this.btnBottomUp.TabIndex = 11;
			this.btnBottomUp.Click += new System.EventHandler(this.btnBottomUp_Click);
			// 
			// btnLeftRight
			// 
			this.btnLeftRight.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.btnLeftRight.Image = ((System.Drawing.Image)(resources.GetObject("btnLeftRight.Image")));
			this.btnLeftRight.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnLeftRight.Location = new System.Drawing.Point(16, 32);
			this.btnLeftRight.Name = "btnLeftRight";
			this.btnLeftRight.Size = new System.Drawing.Size(16, 480);
			this.btnLeftRight.TabIndex = 7;
			this.btnLeftRight.Click += new System.EventHandler(this.btnLeftRight_Click);
			// 
			// pictureBox1
			// 
			this.pictureBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pictureBox1.BB = new System.Drawing.Rectangle(10, 10, 50, 50);
			this.pictureBox1.Location = new System.Drawing.Point(32, 32);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(512, 480);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 6;
			this.pictureBox1.TabStop = false;
			this.pictureBox1.SizeChanged += new System.EventHandler(this.pictureBox1_SizeChanged);
			// 
			// btnTopUp
			// 
			this.btnTopUp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.btnTopUp.Image = ((System.Drawing.Image)(resources.GetObject("btnTopUp.Image")));
			this.btnTopUp.ImageAlign = System.Drawing.ContentAlignment.BottomCenter;
			this.btnTopUp.Location = new System.Drawing.Point(32, 0);
			this.btnTopUp.Name = "btnTopUp";
			this.btnTopUp.Size = new System.Drawing.Size(512, 16);
			this.btnTopUp.TabIndex = 12;
			this.btnTopUp.Click += new System.EventHandler(this.btnTopUp_Click);
			// 
			// btnBottomDown
			// 
			this.btnBottomDown.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.btnBottomDown.Image = ((System.Drawing.Image)(resources.GetObject("btnBottomDown.Image")));
			this.btnBottomDown.ImageAlign = System.Drawing.ContentAlignment.BottomCenter;
			this.btnBottomDown.Location = new System.Drawing.Point(32, 528);
			this.btnBottomDown.Name = "btnBottomDown";
			this.btnBottomDown.Size = new System.Drawing.Size(512, 16);
			this.btnBottomDown.TabIndex = 13;
			this.btnBottomDown.Click += new System.EventHandler(this.btnBottomDown_Click);
			// 
			// btnTopDown
			// 
			this.btnTopDown.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.btnTopDown.Image = ((System.Drawing.Image)(resources.GetObject("btnTopDown.Image")));
			this.btnTopDown.ImageAlign = System.Drawing.ContentAlignment.BottomCenter;
			this.btnTopDown.Location = new System.Drawing.Point(32, 16);
			this.btnTopDown.Name = "btnTopDown";
			this.btnTopDown.Size = new System.Drawing.Size(512, 16);
			this.btnTopDown.TabIndex = 14;
			this.btnTopDown.Click += new System.EventHandler(this.btnTopDown_Click);
			// 
			// btnLeftLeft
			// 
			this.btnLeftLeft.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.btnLeftLeft.Image = ((System.Drawing.Image)(resources.GetObject("btnLeftLeft.Image")));
			this.btnLeftLeft.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnLeftLeft.Location = new System.Drawing.Point(0, 32);
			this.btnLeftLeft.Name = "btnLeftLeft";
			this.btnLeftLeft.Size = new System.Drawing.Size(16, 480);
			this.btnLeftLeft.TabIndex = 15;
			this.btnLeftLeft.Click += new System.EventHandler(this.btnLeftLeft_Click);
			// 
			// btnRightLeft
			// 
			this.btnRightLeft.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.btnRightLeft.Image = ((System.Drawing.Image)(resources.GetObject("btnRightLeft.Image")));
			this.btnRightLeft.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnRightLeft.Location = new System.Drawing.Point(544, 32);
			this.btnRightLeft.Name = "btnRightLeft";
			this.btnRightLeft.Size = new System.Drawing.Size(16, 480);
			this.btnRightLeft.TabIndex = 16;
			this.btnRightLeft.Click += new System.EventHandler(this.btnRightLeft_Click);
			// 
			// btnRightRight
			// 
			this.btnRightRight.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.btnRightRight.Image = ((System.Drawing.Image)(resources.GetObject("btnRightRight.Image")));
			this.btnRightRight.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnRightRight.Location = new System.Drawing.Point(560, 32);
			this.btnRightRight.Name = "btnRightRight";
			this.btnRightRight.Size = new System.Drawing.Size(16, 480);
			this.btnRightRight.TabIndex = 17;
			this.btnRightRight.Click += new System.EventHandler(this.btnRightRight_Click);
			// 
			// ImageCropperUC
			// 
			this.Controls.Add(this.btnRightRight);
			this.Controls.Add(this.btnRightLeft);
			this.Controls.Add(this.btnLeftLeft);
			this.Controls.Add(this.btnTopDown);
			this.Controls.Add(this.btnBottomDown);
			this.Controls.Add(this.btnTopUp);
			this.Controls.Add(this.btnBottomUp);
			this.Controls.Add(this.btnLeftRight);
			this.Controls.Add(this.pictureBox1);
			this.Name = "ImageCropperUC";
			this.Size = new System.Drawing.Size(576, 544);
			this.ResumeLayout(false);

		}
		#endregion


		public Image Image
		{
			get { return pictureBox1.Image; }
			set
			{
				pictureBox1.Image = value;
				if (value != null)
					pictureBox1.BB = new Rectangle(new Point(0, 0), value.Size);
			}
		}

		private void pictureBox1_SizeChanged(object sender, System.EventArgs e)
		{
			Size newSize = pictureBox1.Size;
			newSize.Width += 64;
			newSize.Height += 64;
			this.Size = newSize;
		}

		int m_UnitSize = 10;
		public int UnitSize
		{
			get { return m_UnitSize; }
			set { m_UnitSize = value; }
		}

		private void btnLeftLeft_Click(object sender, System.EventArgs e)
		{
			OffsetLeft(-1);
		}

		private void btnLeftRight_Click(object sender, System.EventArgs e)
		{
			OffsetLeft(1);
		}

		private void btnTopUp_Click(object sender, System.EventArgs e)
		{
			OffsetTop(-1);
		}

		private void btnTopDown_Click(object sender, System.EventArgs e)
		{
			OffsetTop(1);
		}

		private void btnRightLeft_Click(object sender, System.EventArgs e)
		{
			OffsetRight(-1);
		}

		private void btnRightRight_Click(object sender, System.EventArgs e)
		{
			OffsetRight(1);
		}

		private void btnBottomUp_Click(object sender, System.EventArgs e)
		{
			OffsetBottom(-1);
		}

		private void btnBottomDown_Click(object sender, System.EventArgs e)
		{
			OffsetBottom(1);
		}

		void OffsetLeft(int units)
		{
			Rectangle bb = pictureBox1.BB;
			bb.X += units * UnitSize;
			bb.Width -= units * UnitSize;

			if (bb.X < 0)
			{
				bb.Width += bb.X;
				bb.X = 0;
			}
			if (bb.Width < UnitSize)
			{
				bb.X = bb.Right - UnitSize;
				bb.Width = UnitSize;
			}

			pictureBox1.BB = bb;
			pictureBox1.Invalidate();
		}
		void OffsetTop(int units)
		{
			Rectangle bb = pictureBox1.BB;
			bb.Y += units * UnitSize;
			bb.Height -= units * UnitSize;

			if (bb.Y < 0)
			{
				bb.Height += bb.Y;
				bb.Y = 0;
			}
			if (bb.Height < UnitSize)
			{
				bb.Y = bb.Top - UnitSize;
				bb.Height = UnitSize;
			}

			pictureBox1.BB = bb;
			pictureBox1.Invalidate();
		}
		void OffsetRight(int units)
		{
			Rectangle bb = pictureBox1.BB;
			bb.Width += units * UnitSize;

			if (bb.Right > pictureBox1.Width)
			{
				bb.Width = pictureBox1.Width - bb.Left;
			}
			if (bb.Width < UnitSize)
				bb.Width = UnitSize;

			pictureBox1.BB = bb;
			pictureBox1.Invalidate();
		}
		void OffsetBottom(int units)
		{
			Rectangle bb = pictureBox1.BB;
			bb.Height += units * UnitSize;

			if (bb.Bottom > pictureBox1.Height)
				bb.Height = pictureBox1.Height - bb.Top;
			if (bb.Height < UnitSize)
				bb.Height = UnitSize;

			pictureBox1.BB = bb;
			pictureBox1.Invalidate();
		}
	

		public int LeftOffset
		{
			get { return pictureBox1.BB.Left / UnitSize; }
		}
		public int TopOffset
		{
			get { return pictureBox1.BB.Top / UnitSize; }
		}
		public int RightOffset
		{
			get { return (pictureBox1.BB.Right - pictureBox1.Image.Size.Width) / UnitSize; }
		}
		public int BottomOffset
		{
			get { return (pictureBox1.BB.Bottom - pictureBox1.Image.Size.Height) / UnitSize; }
		}
	}
}
