using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

using WOWMapCreator;

namespace WOWMapCreatorUT
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnCreateFullSizeMap;
		private System.Windows.Forms.Button btnCreateThumbNail;
		private WOWMapCreatorUT.ImageCropperUC imageCropperUC1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button btnReadmd5Translate;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnReadmd5Translate = new System.Windows.Forms.Button();
			this.btnCreateFullSizeMap = new System.Windows.Forms.Button();
			this.btnCreateThumbNail = new System.Windows.Forms.Button();
			this.imageCropperUC1 = new WOWMapCreatorUT.ImageCropperUC();
			this.panel1 = new System.Windows.Forms.Panel();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// btnReadmd5Translate
			// 
			this.btnReadmd5Translate.Location = new System.Drawing.Point(24, 8);
			this.btnReadmd5Translate.Name = "btnReadmd5Translate";
			this.btnReadmd5Translate.Size = new System.Drawing.Size(136, 23);
			this.btnReadmd5Translate.TabIndex = 0;
			this.btnReadmd5Translate.Text = "Rename BLP Files";
			this.btnReadmd5Translate.Click += new System.EventHandler(this.btnReadmd5Translate_Click);
			// 
			// btnCreateFullSizeMap
			// 
			this.btnCreateFullSizeMap.Enabled = false;
			this.btnCreateFullSizeMap.Location = new System.Drawing.Point(288, 40);
			this.btnCreateFullSizeMap.Name = "btnCreateFullSizeMap";
			this.btnCreateFullSizeMap.Size = new System.Drawing.Size(128, 23);
			this.btnCreateFullSizeMap.TabIndex = 1;
			this.btnCreateFullSizeMap.Text = "Create Full Size Map";
			this.btnCreateFullSizeMap.Click += new System.EventHandler(this.btnCreateFullSizeMap_Click);
			// 
			// btnCreateThumbNail
			// 
			this.btnCreateThumbNail.Location = new System.Drawing.Point(24, 40);
			this.btnCreateThumbNail.Name = "btnCreateThumbNail";
			this.btnCreateThumbNail.Size = new System.Drawing.Size(136, 23);
			this.btnCreateThumbNail.TabIndex = 2;
			this.btnCreateThumbNail.Text = "Create ThumbNail";
			this.btnCreateThumbNail.Click += new System.EventHandler(this.btnCreateThumbNail_Click);
			// 
			// imageCropperUC1
			// 
			this.imageCropperUC1.Image = null;
			this.imageCropperUC1.Location = new System.Drawing.Point(8, 8);
			this.imageCropperUC1.Name = "imageCropperUC1";
			this.imageCropperUC1.Size = new System.Drawing.Size(440, 440);
			this.imageCropperUC1.TabIndex = 3;
			this.imageCropperUC1.UnitSize = 10;
			// 
			// panel1
			// 
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.panel1.AutoScroll = true;
			this.panel1.Controls.Add(this.imageCropperUC1);
			this.panel1.Location = new System.Drawing.Point(8, 80);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(704, 672);
			this.panel1.TabIndex = 4;
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(720, 757);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.btnCreateThumbNail);
			this.Controls.Add(this.btnCreateFullSizeMap);
			this.Controls.Add(this.btnReadmd5Translate);
			this.Name = "Form1";
			this.Text = "WOWMapGen";
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void btnReadmd5Translate_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog dlg = new OpenFileDialog();
			dlg.Filter = "TRS Files|*.TRS";
			dlg.RestoreDirectory = true;

			if (dlg.ShowDialog() == DialogResult.OK)
			{
				(new WOWMapCreator.WOWMapCreator()).MoveImagesToFolders(dlg.FileName, Path.GetDirectoryName(dlg.FileName));
			}
		}

		string m_SelectedPath;

		private void btnCreateFullSizeMap_Click(object sender, System.EventArgs e)
		{
			SaveFileDialog dlg = new SaveFileDialog();
			dlg.InitialDirectory = m_SelectedPath;
			dlg.Filter = "BMP Files(*.BMP)|*.bmp";
			
			if (dlg.ShowDialog() == DialogResult.OK)
			{
				int leftOffset = imageCropperUC1.LeftOffset;
				int rightOffset = imageCropperUC1.RightOffset;
				int topOffset = imageCropperUC1.TopOffset;
				int botOffset = imageCropperUC1.BottomOffset;

				string[] bmpFiles = Directory.GetFiles(m_SelectedPath, "*.bmp");
				Image img = (new WOWMapCreator.WOWMapCreator()).MakeMap(1, leftOffset, topOffset, rightOffset, botOffset, bmpFiles);
				img.Save(dlg.FileName);
				img.Dispose();
			}
		}

		private void btnCreateThumbNail_Click(object sender, System.EventArgs e)
		{
			FolderBrowserDialog dlg = new FolderBrowserDialog();
			dlg.SelectedPath = @"D:\Games\WOWData\";
			
			if (dlg.ShowDialog() == DialogResult.OK)
			{
				m_SelectedPath = dlg.SelectedPath;
				string[] blpFiles = Directory.GetFiles(dlg.SelectedPath, "*.blp");
				(new WOWMapCreator.WOWMapCreator()).ConvertBLPToTGA(blpFiles);

				string[] tgaFiles = Directory.GetFiles(dlg.SelectedPath, "*.tga");
				(new WOWMapCreator.WOWMapCreator()).ConvertTGAToBMP(tgaFiles);

				string[] bmpFiles = Directory.GetFiles(dlg.SelectedPath, "*.bmp");
				imageCropperUC1.UnitSize = (int)(256 * 0.0625f);

				imageCropperUC1.Image = (new WOWMapCreator.WOWMapCreator()).MakeMap(0.0625f, 0, 0, 0, 0, bmpFiles);

				btnCreateFullSizeMap.Enabled = true;
			}
		}

	}
}
