namespace eval TslcDES {

	# create a seconday hex-code by encrypting "MyKey" with
	# key embedded in app.
	set a [StaticKey Encrypt MyKey]; # 8 characters or less

	# display it
	puts $a

	# encode arbitrary data with hex-code
	set e [StaticEncode $a {My data to encode}]

	# display it
	puts $e

	# lock out encode/decode operatons
	StaticKey lock; # default state is locked - see StaticScriptLocked in uTslcCmp.pas
	
	# try to do something like decode data
	if [catch {

			puts [StaticDecode $a $e]

		} err] {

		puts "failed to decode"
	}

	# unlock using the hardwired secondary key (see end of TslcKey.pas)
	# which uses the same character pattern as above; i.e., "MyKey"
	StaticKey unlock "MyKey"
		
	# let's try to decode again
	puts [StaticDecode $a $e]
	
	# done
	puts "Finished!"

}
