if [info exists tslc_pad] {
	set argv "-use [TkPad panel TkPanel -focus]"
}

if {[info commands ::policy] != {}} {
	policy trusted
}

package require Tk 8.0
package require TslcBDE 1.0


set bde_lib $tslc_library/bde1.0

if { ![TslcBDE::Session IsAlias DBDEMOS] } {
	puts stderr "Creating alias DBDEMOS"
	TslcBDE::Session AddAlias DBDEMOS Standard \
		"-oPath=[file nativename [file join $bde_lib data]]" \
		"-oDefault Driver=Paradox"
}

proc GetGIF { gif } {
	global bde_lib
	return [image create photo -file [file join $bde_lib images $gif.gif]]
}

proc QueryDelete { dataSet } {
	if {[tk_messageBox -icon warning -title Warning \
			-message "Delete Record?" -type yesno -default no] == "yes" } {
		$dataSet Delete
	}
}

proc DoStateChange { nav dsCmd } {
#	puts "$dsCmd state change: [$dsCmd State]"
	set last [$dsCmd Props Value $nav.LastState]
	switch [string tolower [$dsCmd State]] {
		inactive {
			foreach w [winfo children $nav] {
				$w config -state disabled
			}
		}
		
		browse {
			$nav.first config -state normal
			$nav.prior config -state normal
			$nav.next config -state normal
			$nav.last config -state normal
			$nav.insert config -state normal
			$nav.delete config -state normal
			$nav.edit config -state normal
			$nav.post config -state disabled
			$nav.cancel config -state disabled
			$nav.refresh config -state normal
		}

		insert -
		edit {
			$nav.edit config -state disabled
			$nav.post config -state normal
			$nav.cancel config -state normal
		}

	}
	if { $last == "Inactive"  || $last == {}} {
		set d [$dsCmd DataSet]
		$nav.first config -command "$d First"
		$nav.prior config -command "$d Prior"
		$nav.next config -command "$d Next"
		$nav.last config -command "$d Last"
		$nav.insert config -command "$d Insert"
		$nav.delete config -command "QueryDelete $d"
		$nav.edit config -command "$d Edit"
		$nav.post config -command "$d Post"
		$nav.cancel config -command "$d Cancel"
		$nav.refresh config -command "$d Refresh"
	}		
	$dsCmd Props Value $nav.LastState [$dsCmd State]
}

proc DoDataChange { nav dsCmd } {
	set d [$dsCmd DataSet]
	if {$d == {}} { return }
	set head normal
	set tail normal
	set x 0
	if [$d EOF] {
		set tail disabled
		incr x
	}
	if [$d BOF] {
		set head disabled
		incr x
	}
	$nav.first config -state $head
	$nav.prior config -state $head
	$nav.next config -state $tail
	$nav.last config -state $tail
	if {$x == 2} {
		$nav.delete config -state disabled
	}
}


proc DBNavigator.Create { w {btns {}}} {
	set x 0
	foreach b {first prior next last insert delete edit post cancel refresh} {
		button $w.$b -image [GetGIF $b] -state disabled
		if {$btns == {} || [lsearch $btns $b] >= 0 } {
			grid $w.$b -column $x -row 0
			incr x
		}
	}
}

proc DBNavigator.DataSource { w src } {
	if {$src == {}} {
		return
	}
	set s [format "%s_%s" $w StateId]
	set prev [$src Props Value $s]
	if {$prev != {}} {
		$src OnStateChange Delete $prev
	}
	set id [$src OnStateChange Add "DoStateChange $w"]
	$src Props Value $s $id
		
	set d [format "%s_%s" $w DataId]
	set prev [$src Props Value $d]
	if {$prev != {}} {
		$src OnDataChange Delete $prev
	}
	set id [$src OnDataChange Add "DoDataChange $w"]
	$src Props Value $d $id
}


set err [catch {
	frame .nav -height 30 -bd 2 -relief raised -background #888888
	pack .nav -ipadx 2 -ipady 2
	frame .body
	pack .body -fill both
	label .body.name -textvariable Customer(Company)
	entry .body.name2 -textvariable Customer(Company)
	button .body.active -text Close -command { 
		if [Customer Active] { 
			Customer Close
			.body.active config -text Open
		} else {
			Customer Open
			.body.active config -text Close
		} 
	}
	pack .body.name .body.name2 .body.active
	listbox .body.list -yscrollcommand {.body.list.yscroll set } -font {Courier 8}
	scrollbar .body.list.yscroll -command ".body.list yview"	
	place .body.list -x 5 -y 5 -width 250 -height 50
	pack .body.list.yscroll -anchor e

	TslcBDE::Table -db DBDEMOS -table Customer Customer
	TslcBDE::DataSource CustomerSource
	CustomerSource DataSet Customer

	DBNavigator.Create .nav
	DBNavigator.DataSource .nav CustomerSource
	Customer Open -desc
	set fmt "%-15.15s | %-4.4s | %-8.8s"
		for { set x 0} {$x < [Customer FldDesc Count] } { incr x} {
		set n [Customer FldDesc $x Name]
		set u1 [Customer FldDesc $x units1]
		set t [Customer FldDesc $x fldType]
		.body.list insert end [format $fmt $n $u1 $t]
	}
	puts [CustomerSource LinkVar Customer]
	tkwait variable v
} errmsg]
catch {Customer Free}
catch {CustomerSource Free}
catch { foreach w [winfo children .] {
		destroy $w
	}
}
if $err { puts $errmsg}

