# SockClnt.tcl --

#

#	Opens a client socket on 127.0.0.1, localhost. Sends a few lines of 
#	text to the server socket which in turn *puts* the data to the servers
#	stdout. Run the SockServ.tcl in a seperate process prior to invoking
#	this script.
#
#	Note that a server terminated host/port pair appears not reopen on a
#	client during a given session despite reactivation of the host/port pair
#	by a server. 
#

# Copyright (c) 1996 - 1997, William Byrne

#

# See the file "license.txt" for information on usage and redistribution

# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

#



# Open a channel on localhost port 100
set ch [socket 127.0.0.1 100]

# Put in catch block to ensure closure of channel
if [catch {
	# display channel id on client stdout
	puts $ch

	# send 10 lines of text to server
	for { set i 0 } { $i < 10 } { incr i } {

		# note the additional arg to *puts*. Two args implies
		# the first arg is a channel id
		puts $ch [format "%d OK" $i]
			
		# force output of data. See *fconfigure* in on-line help
		flush $ch
	}

	# give sockets some time to process
	after 3000

	# send term character. This may be innocuous. See the SockServ.tcl script.
	puts $ch "!"
	flush $ch

} err] {
	# paranoid... definitely want to close the channel
	catch { puts "$err\n$errorInfo" }
}

close $ch
