# Macros.tcl --
#
#	Useful/Useless Macro routines. Macros will appear under menu Edit->Script
#
# Copyright (c) 1996 - 1997, William Byrne
#
# See the file "license.txt" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

package require IDE 1.0

# Create a macro that inserts a trace debug statement at cursor
Macro -ki -sshift -salt -c&Insert {
	IDE::insertAt "\{\$IFDEF TRACE\}\n    TraceFmt('%s %s',\[ClassName, Name]);\n\{\$ENDIF\}\n"
}

# Macro that Runs executable from Project Directory
Macro -kVK_F9 -sctrl -salt {-c&Run Project Dir} {
	cd [file dirname [IDE Tools ProjectName]]
	after 1000
	IDE ProcessMessages
	IDE Menu VK_F10 R R
}

# Macro that changes to Project Directory
Macro -kd {-cProject &Directory} -sshift -salt {cd [file dirname [IDE Tools ProjectName]]}

# Print Macro
Macro -kq -sshift -salt -cPri&nt {IDE MENU VK_F10 VK_DOWN P}


# The following scripts provide a Tk pop-up window of favorite projects.

namespace eval Macros {
	export Favorites
}

# The following was chopped from Sun.Tk.Dialog.tcl
proc Macros::Favorites { w title lst } {
    global tkPriv tcl_platform tk_library

    package requires Tk 8.0

    set default 1
    set tkPriv(openProject) {}

    # Hide main window if not embedded
	if ![TkPad isembedded .] then
	    wm withdraw .

    # 1. Create the top-level window and divide it into top
    # and bottom parts.

    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $title
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    # The following command means that the dialog won't be posted if
    # [winfo parent $w] is iconified,  but it's really needed;  otherwise
    # the dialog can become obscured by other windows in the application,
    # even though its grab keeps the rest of the application from being used.

    wm transient $w [winfo toplevel [winfo parent $w]]

    frame $w.bot
    frame $w.top
    pack $w.bot -side bottom -fill both
    pack $w.top -side top -fill both -expand 1

    # 2. Fill the top part with Project data

    for { set x 0 } { $x < [llength $lst] } { incr x } {
        radiobutton $w.top.radio$x -justify left -text "[lindex $lst $x]" -value $x -variable tkPriv(openProject)
        pack $w.top.radio$x -side top -anchor w
    }


    # 3. Create a row of buttons at the bottom of the dialog.

    button $w.ok -text OK -command "set tkPriv(button) 0"
    $w.ok configure -default active
    grid $w.ok -in $w.bot -column 0 -row 0 -sticky ew -padx 10 -pady 5
    grid columnconfigure $w.bot 0


    button $w.cancel -text Cancel -command "set tkPriv(button) 1"
    $w.cancel configure -default normal
    grid $w.cancel -in $w.bot -column 1 -row 0 -sticky ew -padx 10 -pady 5
    grid columnconfigure $w.bot 1


    # 4. Create a binding for <Return> on the dialog if there is a
    # default button.

    if {$default >= 0} {
	bind $w <Return> "
	    $w.ok configure -state active -relief sunken
	    update idletasks
	    after 100
	    set tkPriv(button) $default
	"
    }

    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> {set tkPriv(button) -1}
    bind $w <Escape> {set tkPriv(button) 1}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
#    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    update idletasks
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus  -force $w.ok

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable tkPriv(button)
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# tkPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    if { $tkPriv(button) == 0 && $tkPriv(openProject) != {} } {
	IDE openproject [file nativename [lindex $lst $tkPriv(openProject)]]
    } else {
       return 0
    }
}

Macro -kVK_F3 -sctrl -salt {-c&Favorites} {
	IDE::Favorites .favs "Favorites" [list \
    	[file join [file dirname $tslc_library] projects TslcCon.dpr]
        d:\_code\projects\scout\scout.dpr \
        d:\_code\heath\heathapp.dpr \
        ]
	}

}



