{ -----------------------------------------------------------------------
Tcl Scripting Language Components (Tslc)
Copyright (C) 1996-2002 William Byrne

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

WilliamB@ByrneLitho.com
------------------------------------------------------------------------}
unit TslcImg;

interface
uses classes;

function TslcLoadImageResource(module: integer; filename, name: string; doEncode64: boolean): TMemoryStream;

implementation
uses SysUtils, TslcRsrc, TslcZLib;

function encode64(src: pChar; srclen: integer; dest: pChar; destlen: integer):integer; cdecl; external;
{$L encode64.obj}

function TslcLoadImageResource(module: integer; filename, name: string; doEncode64: boolean): TMemoryStream;
var
	tmp, tmp2: TMemoryStream;
begin
    tmp := TslcLoadBinaryResource(module, filename, name);
    try
		tmp2 := TMemoryStream.Create;
        try
        	InflateStream(tmp, tmp2);
            tmp2.position := 0;
            if doEncode64 then
            begin
				result := TMemoryStream.Create;
			    try
			    	result.SetSize(round(tmp2.Size * 1.4));
					if encode64(tmp2.Memory, tmp2.Size, result.Memory, result.Size) <> 0 then
		    	    	raise EInOutError.Create('unable to encode64 - stream buffer not large enough');
			    except
	    	    	result.Free;
	        	    raise;
			    end;
            end else
            begin
    			result := tmp2;
                tmp2 := nil;
            end;
        finally
        	tmp2.Free;
        end;
	finally
    	tmp.Free;
    end;
end;


end.
