{ -----------------------------------------------------------------------
Tcl Scripting Language Components (Tslc)
Copyright (C) 1996-2002 William Byrne

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

WilliamB@ByrneLitho.com
------------------------------------------------------------------------}
unit Phantom;

///////////////////////////////////////////////////////////////////////////////
//
//  TclDbTbl.pas
//	Copyright(c) 1996-1997 William Byrne
//		WilliamB@ByrneLitho.com
//		76262.13@CompuServe.com
//
//	All rights reserved.
//  	William Byrne makes no representations about the suitability of this
//    	software for any purpose.  It is provided "as is" without express or
//    	implied warranty.
//
//	Usage
//      I hereby grant to the legal purchasors of the source code contained
//      herein a non-exclusive license for the use of said source code in
//      developing compiled, executable software, and for the distribution of
//      said source code as part of said developed, compiled, executable software.
//
//  Purpose:
//		This file provides for Bde Table Manipulation using the
//		Tcl Scripting Language Components.
//
//	Editor:
//		Tab stops = 4
//		Page width = 132 characters
//		Font = Courier New, 8pt
//
//  Misc:
//      ??? = Note to self

{$Z+}
{$D-,L-,Y-}

interface
uses Windows, Classes, Controls;

procedure DrawPhantom(ctrl: TControl; rect: TRect);

implementation

procedure DrawPhantom(ctrl: TControl; rect: TRect);
var
	region: HRGN;
    dc, prevBrush, prevPen, pen: THandle;
	scrnPos: TPoint;
    clientRect: TRect;
begin
	 	scrnPos := ctrl.clientToScreen(point(0,0));
    	clientRect := ctrl.clientRect;
	    OffsetRect(clientRect, scrnPos.x, scrnPos.y);

	  	dc := GetDC(0);
		SetViewPortOrgEx(dc, scrnPos.x, scrnPos.y, nil);
	    region := CreateRectRgnIndirect(clientRect);
	    SelectClipRgn(dc, region);
	    DeleteObject(region);

		prevBrush := SelectObject(dc, GetStockObject(HOLLOW_BRUSH));
		pen := CreatePen(PS_SOLID, 2, 0);
		prevPen	:= SelectObject(dc, pen);
	    SetROP2(dc, R2_NOT);

		with rect do
	    	Rectangle(dc, left, top, right, bottom);

		SelectObject(dc, prevBrush);
		SelectObject(dc, prevPen);
		DeleteObject(pen);
		ReleaseDC(0, dc);
end;


end.
