unit TslcReg;
{ -----------------------------------------------------------------------
Tcl Scripting Language Components (Tslc)
Copyright (C) 1996-2002 William Byrne

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

WilliamB@ByrneLitho.com
------------------------------------------------------------------------}
interface
uses Windows, TslcEdit, TslcParm, DsgnIntf, Classes, SysUtils, TslcRDat, TkPanel, Tslc;

procedure Register;

implementation
{$D-,L-,Y-}
type
    TTclEditor = class(TComponentEditor)
	    procedure ExecuteVerb(Index: Integer); override;
    	function GetVerb(Index: Integer): string; override;
    	function GetVerbCount: Integer; override;
  	end;

	TTclCmdParamPosProperty = class(TIntegerProperty)
  	public
  		procedure Edit; override;
  	end;


procedure TTclEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: ShowTclDesigner(Designer, TTcl(Component));
//  1: ShowRegInfo( TslcLice.TslcLicense, format('v%s ',[TslcIssue]), nil );
  end;
end;

function TTclEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := 'Edit';
    1: Result := 'About';
  end;
end;

function TTclEditor.GetVerbCount: Integer;
begin
  Result := 2;
end;

{~~~ TTclCmdParamPosProperty ~~~}

procedure TTclCmdParamPosProperty.Edit;
var
	frm: TParamPosForm;
begin
//	frm := TParamPosForm.Create(Application);
	frm := TParamPosForm.Create(nil);
    try
    	frm.Value := GetOrdValue;
        if frm.Execute then
        	SetOrdValue( frm.Value );
    finally
    	frm.free;
    end;
end;


procedure Register;
begin
	try
		RegisterComponentEditor(TTcl, TTclEditor);
	    RegisterPropertyEditor(TypeInfo(TTclCmdParamPos), TTclCmdParam, 'Position', TTclCmdParamPosProperty);
	    RegisterNoIcon([TTclCommand, TTclTrace, TTclCmdSwitch, TTclCmdParam]);
	    RegisterClasses([TTclCommand, TTclTrace, TTclCmdSwitch, TTclCmdParam]);
	  	RegisterComponents(GetTclPaletteName, [TTcl, TTclBridge, TTclEventSource, TTclTimer, TTclChannel, TTkPanel, TTkScrollBox]);
	except
    	MessageBox(0, pChar(Exception(ExceptObject).Message), 'Tslc Registration Error', MB_TASKMODAL);
    end;
end;


end.
