{ -----------------------------------------------------------------------
Tcl Scripting Language Components (Tslc)
Copyright (C) 1996-2002 William Byrne

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

WilliamB@ByrneLitho.com
------------------------------------------------------------------------}
unit TslcParm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, DsgnIntf;

type

	TTclCmdParamPos = longInt;

  TParamPosForm = class(TForm)
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    CheckBox17: TCheckBox;
    CheckBox18: TCheckBox;
    CheckBox19: TCheckBox;
    CheckBox20: TCheckBox;
    CheckBox21: TCheckBox;
    CheckBox22: TCheckBox;
    CheckBox23: TCheckBox;
    CheckBox24: TCheckBox;
    CheckBox25: TCheckBox;
    CheckBox26: TCheckBox;
    CheckBox27: TCheckBox;
    CheckBox28: TCheckBox;
    CheckBox29: TCheckBox;
    CheckBox30: TCheckBox;
    CheckBox31: TCheckBox;
    CheckBox32: TCheckBox;
    BtnSelectAll: TBitBtn;
    BtnDeselectAll: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    function  GetValue: TTclCmdParamPos;
    procedure SetValue(AValue: TTclCmdParamPos);
    procedure FormCreate(Sender: TObject);
    procedure BtnSelectAllClick(Sender: TObject);
    procedure BtnDeselectAllClick(Sender: TObject);
  private
    { Private declarations }
    bits: array[0..31] of TCheckBox;
  public
    { Public declarations }
    function Execute: boolean;
    property Value: TTclCmdParamPos read GetValue write SetValue;
  end;

implementation
{$D-,I-,Y-}
{$R *.DFM}


function TParamPosForm.Execute: boolean;
begin
	result := ShowModal = mrOK;
end;

function TParamPosForm.GetValue: TTclCmdParamPos;
var
	x: integer;
begin
	Result := 0;
	for x:= 0 to 31 do
    	if bits[x].Checked then
        	Result := Result or (1 shl x);
end;

procedure TParamPosForm.SetValue(AValue: TTclCmdParamPos);
var
	x: integer;
begin
	for x := 0 to 31 do
        bits[x].Checked := ((1 shl x) and AValue) <> 0;
end;

procedure TParamPosForm.FormCreate(Sender: TObject);
var
	x: integer;
begin
	for x:= 0 to 31 do
    	bits[x] := TCheckBox(FindComponent('CheckBox' + inttostr(x + 1)));
end;

procedure TParamPosForm.BtnSelectAllClick(Sender: TObject);
var
	x: integer;
begin
	for x:= 0 to 31 do
    	bits[x].Checked := True;
end;

procedure TParamPosForm.BtnDeselectAllClick(Sender: TObject);
var
	x: integer;
begin
	for x:= 0 to 31 do
    	bits[x].Checked := False;
end;

end.
