library TslcUtil;

uses
	Windows,
    SysUtils,
	TclTk,
	Tslc,
  TraceUti in 'TraceUti.pas',
  uTslcUti in '..\..\ext\uTslcUti.pas' {UtilityMod: TDataModule};

function Tslcutility_Init(AInterp: pTcl_Interp): integer; cdecl
begin
    try
		UtilityServeThreadInterp(GetCurrentThreadId, AInterp);
        result := TCL_OK;
	except
		Tcl_SetResult(AInterp, pChar(Exception(ExceptObject)), TTclFreeProc(TCL_VOLATILE));
		result := TCL_ERROR;
    end;
end;

function Tslcutility_SafeInit(AInterp: pTcl_Interp): integer; cdecl
begin
	result := Tslcutility_Init(AInterp); // Module knows how to handle Safe interpreters.
end;

exports
    Tslcutility_Init name 'Tslcutil_Init', // for straight-up *load*
    Tslcutility_SafeInit name 'Tslcutil_SafeInit',  // for straight-up *load*
    Tslcutility_Init,  // for package require
    Tslcutility_SafeInit; // for package require

begin
end.

