library TslcStub;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  View-Project Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the DELPHIMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using DELPHIMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
	Tslc,
  uStub in 'uStub.pas' {DataModule1: TDataModule};


// The following export declarations are all that is necessary to
// promote the uTslcCmp module as a loadable script package.
// All TTcl objects like the one in uStub.pas are listed in a static list.
// Each object in the list with the property AutoActive set true will be used
// as a server for any interpreters that a passed through the exports below.
// When a package such as this is loaded by another script, the calling interpreter
// attempts to bind and execute exported procedures named after the file name of
// the loaded DLL. In this case, Tslc_Init and Tslc_SafeInit ( static exports in Tslc.dcu )
// are required to be named Tslcstub_Init and Tslcstub_SafeInit respectively. The Tcl engine
// forms strings base on the name of the loaded DLL; these strings are used to reference
// the exported initialization procedures required for a successful package load.
// Note the required initial capitalization on the words in the export names.
//
// For packages that are loaded by virtue of a *package require MyPackage* expression, exports
// will need to be available after the name of the package; e.g., Tslcmypackage_Init. When a
// library package is loaded explicitely by a *load ./MyPkg* expression, the exports required
// will be Tclmypkg_Init and Tclmypkg_SafeInit. It would be a good idea to provide exports
// for both situations.

exports
	Tslc_Init name 'Tslcstub_Init',
    Tslc_SafeInit name 'Tslcstub_SafeInit';

begin
end.
