{ -----------------------------------------------------------------------
Tcl Scripting Language Components (Tslc)
Copyright (C) 1996-2002 William Byrne

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

WilliamB@ByrneLitho.com
------------------------------------------------------------------------}
unit uTslcOle;

interface

uses
  OleAuto, Tslc;

type
  TTslc = class(TAutoObject)
  private
    { Private declarations }
    FTcl: TTcl;
  public
  	constructor Create; override;
    destructor Destroy; override;
  automated
    { Automated declarations }
    function Evaluate(expr: string): string;
  end;

implementation


constructor TTslc.Create;
begin
	inherited Create;
    FTcl := TTcl.Create(nil);
end;

destructor TTslc.Destroy;
begin
	inherited Destroy;
    FTcl.Free;
end;

function TTslc.Evaluate(expr: string): string;
begin
	result := FTcl.Eval(expr);
end;


procedure RegisterTslc;
const
  AutoClassInfo: TAutoClassInfo = (
    AutoClass: TTslc;
    ProgID: 'Project1.Tslc';
    ClassID: '{04FF8720-90B1-11D0-9B8D-0060088DCACF}';
    Description: 'Tcl Scripting Language Components Interface';
    Instancing: acMultiInstance);
begin
  Automation.RegisterClass(AutoClassInfo);
end;

initialization
  RegisterTslc;
end.
