{ -----------------------------------------------------------------------
Tcl Scripting Language Components (Tslc)
Copyright (C) 1996-2002 William Byrne

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

WilliamB@ByrneLitho.com
------------------------------------------------------------------------}
unit uTslcCon;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TclTk, Tslc;

type
  TDataModule1 = class(TDataModule)
    Tcl1: TTcl;
    TclBridge1: TTclBridge;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Run;
  end;

var
  DataModule1: TDataModule1;

implementation
uses TkMain, uTslcCmp, TkConsole;
{$R *.DFM}


function OnCreateInterp: pTcl_Interp;
begin
	result := Tcl_CreateInterp;
    CompressMod.TclSource.ServiceInterp(result);
end;

procedure TDataModule1.Run;
begin
	TkConsole.InterpCreateProc := @OnCreateInterp;
	try
		InitTk('');
        TclBridge1.Client := Tcl1;
        TclBridge1.Server := CompressMod.TclSource;
		Tcl1.Open;
        Tcl1.Eval('set tcl_interactive 1');
        if Tcl_Init(Tcl1.Interp) = TCL_ERROR then
        	TclError(Tcl_GetStringResult(Tcl1.Interp));
        if Tk_Init(Tcl1.Interp) = TCL_ERROR then
        	TclError(Tcl_GetStringResult(Tcl1.Interp));
        Tcl_StaticPackage(Tcl1.Interp, 'Tk', Tk_Init, Tk_SafeInit);
		Tslc_Main(Tcl1.Interp);
    except
    	MessageBox(0, pChar(Exception(ExceptObject).Message), 'Error', MB_ICONSTOP);
    end;
end;



initialization
	DataModule1 := TDataModule1.Create(nil);
	SetEnvironmentVariable('TCL_LIBRARY', '/tcl8.0');
	SetEnvironmentVariable('TK_LIBRARY', '/tk8.0');

finalization
	DataModule1.Free;
end.
