{ -----------------------------------------------------------------------
Tcl Scripting Language Components (Tslc)
Copyright (C) 1996-2002 William Byrne

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

WilliamB@ByrneLitho.com
------------------------------------------------------------------------}
unit uSimple;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Tslc;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    TclChannel1: TTclChannel;
    Tcl1: TTcl;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure TclChannel1Output(Sender: TTclChannel; buf: PChar;
      toWrite: Integer; var errorCode, result: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
	Memo2.Clear;
	if not Tcl1.Eval(Memo1.text) then
    	Memo2.Lines.add('****** ERROR *******');
    Memo2.Lines.add(Tcl1.Result);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
	with OpenDialog1 do
		if Execute then
        	Memo1.Lines.LoadFromFile(FileName);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
	with SaveDialog1 do
    	if Execute then
        	Memo1.Lines.SaveToFile(FileName);
end;

procedure TForm1.TclChannel1Output(Sender: TTclChannel; buf: PChar;
  toWrite: Integer; var errorCode, result: Integer);
var
	str: string;
begin
	SetString(str, buf, toWrite);
    Memo2.Lines.add(str);
end;

end.
