program ScriptPd;

uses
//{$IFDEF TSLC_OLE}
//	OleAuto,
//{$ENDIF} Commented because the addition of new forms to this project causes Delphi to delete this {$ENDIF} line.
  Windows,
  Messages,
  Forms,
  Tslc,
  SysUtils,
  uPadLine,
  //TslcPkg4,
  TslcPad in '..\..\ext\TslcPad.pas' {ScriptPad};

{$R *.RES}


//{$DEFINE TSLC_SECURE} // no effect on TslcPad.pas; it needs its own define.


var
	ScriptPad: TScriptPad;

begin


	if tslc_ide then // If error, edit top of TslcPad.pas file; improper DEFINEs. This will be optimized if false.
    	raise Exception.Create(tslc_ide_error);

	ShowWindow(Application.Handle, SW_HIDE);
    try
        ParseCmdLine(LoadBDE, LoadCompress, LoadUtility, LoadWait); // Vars declared in TslcPad
    except
    	MessageBox(0, pChar(Exception(ExceptObject).Message), 'Error', 0);
        exit;
    end;

    Application.Title := 'Script Pad';
  Application.CreateForm(TScriptPad, ScriptPad);
  if EvalFile <> '' then
    begin
        try
	        ScriptPad.OpenScript(EvalFile, EvalPassword);
    	    if EvalSilent then
        	begin
    			ScriptPad.Evaluate;
                if EvalClose then
                begin
                	ScriptPad.Free;
                    exit;
                end;
			end;
		except
	    	MessageBox(0, pChar(Exception(ExceptObject).Message), 'Error', 0);
            ScriptPad.Free;
            exit;
        end;
    end;
{$IFDEF TSLC_SECURE}
    if AccessPassword = '' then
    	if not ScriptPad.InputPassword('Enter Access Password:', AccessPassword) then
        begin
        	ScriptPad.Free;
        	exit;
        end;

    try
		VerifyAccess(AccessPassword);
    except
    	MessageBox(0, pChar(Exception(ExceptObject).Message), 'Error', 0);
        ScriptPad.Free;
		exit;
    end;
{$ENDIF}

//	CheckHashCollisionsAll;
	with Application do
    begin
{$IFDEF TSLC_OLE}
    	Initialize;
		if smAutomation = Automation.StartMode then
    	begin // not very silent, but silent enough.
        	repeat
        		HandleMessage
        	until Terminated;
            ScriptPad.Free;
    	end else
{$ELSE}
		if True then
{$ENDIF}
	    begin
			ShowWindow(Handle, SW_SHOW);
			if ScriptPad = nil then
			    CreateForm(TScriptPad, ScriptPad);
			Run;
	    end;
    end;

end.
