unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    memCode: TMemo;
    btnRun: TButton;
    btnA: TButton;
    btnB: TButton;
    btnC: TButton;
    chkRegist: TCheckBox;
    procedure btnRunClick(Sender: TObject);
    procedure btnAClick(Sender: TObject);
    procedure btnBClick(Sender: TObject);
    procedure btnCClick(Sender: TObject);
  private
    { Private 錾 }
    Running: Boolean;
    procedure Pushed(Button: TButton);
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  lua, lualib, lauxlib, LuaUtils;

function FindButton(AOwner: TComponent; Caption: string): TButton;
// AOwner ȉ Caption {^T
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to AOwner.ComponentCount - 1 do
  begin
    if (AOwner.Components[I] is TButton) then
    begin
      if ((AOwner.Components[I] as TButton).Caption = Caption) then
      begin
        Result := AOwner.Components[I] as TButton;
        Exit;
      end;
    end else
    begin
      Result := FindButton(AOwner.Components[I], Caption);
      if (Assigned(Result)) then
        Exit;
    end;
  end;
end;

function LuaPushButton(L: Plua_State): Integer; cdecl;
var
  S: string;
  Button: TButton;
begin
  if (lua_gettop(L) <> 1) then
    luaL_error(L, '̐Ⴂ܂');

  S := lua_tostring(L, 1);
  Button := FindButton(Form1, S);
  if (not Assigned(Button)) then
    luaL_error(L, PChar('{^' + S + '܂'));

  Button.Click;
  Result := 0;
end;

procedure TForm1.btnRunClick(Sender: TObject);
var
  L: Plua_State;
begin
  L := lua_open;
  Running := True;
  try
    LuaRegister(L, 'Push', LuaPushButton);
    LuaLoadBuffer(L, memCode.Text, 'code');
    LuaPCall(L, 0, 0, 0);
  finally
    Running := False;
    lua_close(L);
  end;
end;

procedure TForm1.btnAClick(Sender: TObject);
begin
  Pushed(Sender as TButton);
  MessageDlg('{^A', mtInformation, [mbOK], 0);
end;

procedure TForm1.btnBClick(Sender: TObject);
begin
  Pushed(Sender as TButton);
  MessageDlg('{^B', mtWarning, [mbOK], 0);
end;

procedure TForm1.btnCClick(Sender: TObject);
begin
  Pushed(Sender as TButton);
  MessageDlg('{^C', mtError, [mbOK], 0);
end;

procedure TForm1.Pushed(Button: TButton);
begin
  if (not chkRegist.Checked) or (Running) then
    Exit;

  memCode.Lines.Add(Format('Push("%s")', [Button.Caption]));
end;

end.
