unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, lua, lualib, lauxlib, LuaUtils;

type
  TfrmMain = class(TForm)
    memCode: TMemo;
    memLog: TMemo;
    btnSave: TButton;
    btnClear: TButton;
    btnMatch: TButton;
    btnSubst: TButton;
    btnSplit: TButton;
    btnTrans: TButton;
    edtMatch: TEdit;
    edtSubst: TEdit;
    edtSplit: TEdit;
    edtTrans: TEdit;
    edtFileName: TEdit;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure btnMatchClick(Sender: TObject);
    procedure btnSubstClick(Sender: TObject);
    procedure btnSplitClick(Sender: TObject);
    procedure btnTransClick(Sender: TObject);
  private
    { Private 錾 }
    procedure Put(const S: string);
    procedure Setup(L: PLua_State);
    procedure Execute(const FuncName, RE: string; NResult: Integer);
  public
    { Public 錾 }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

uses
  LuaBRegExp;

procedure DoLuaStdout(S: PChar; N: Integer);
const
  CR = #$0D;
  LF = #$0A;
  CRLF = CR + LF;
begin
  frmMain.Put(StringReplace(S, LF, CRLF, [rfReplaceAll]));
end;

procedure TfrmMain.Setup(L: PLua_State);
begin
  OnLuaStdout := DoLuaStdout;
  luaopen_base(L);
  luaopen_table(L);
  luaopen_io(L);
  luaopen_string(L);
  luaopen_math(L);
  luaopen_debug(L);
  luaopen_loadlib(L);
  lua_settop(L, 0);

  LuaRegister(L, 'print', lua_print);
  LuaRegister(L, 'io.write', lua_io_write);
  LuaBRegExpRegister(L, 0);
  LuaLoadBuffer(L, memCode.Text, 'code');
  lua_settop(L, 0);
  lua_dostring(L, PChar(memCode.Text));
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  Names: TLuaBRegExpNames;
begin
  LuaBRegExpGetNames(Names);
  // KvΊ֐ύX
  LuaBRegExpSetNames(Names);
  memCode.Lines.LoadFromFile('default.lua');
  memLog.Clear;
end;

procedure TfrmMain.btnSaveClick(Sender: TObject);
begin
  memCode.Lines.SaveToFile('default.lua');
end;

procedure TfrmMain.Put(const S: string);
begin
  with (memLog) do
  begin
    SelStart := Length(Text);
    SelLength := 0;
    SelText := S;
  end;
end;

procedure TfrmMain.btnClearClick(Sender: TObject);
begin
  memLog.Clear;
end;

procedure TfrmMain.Execute(const FuncName, RE: string; NResult: Integer);
var
  L: Plua_State;
  S: TStrings;
begin
  btnClearClick(Self);
  S := TStringList.Create;
  L := lua_open;
  try
    Setup(L);
    lua_getglobal(L, PChar(FuncName));
    if (lua_type(L, -1) <> LUA_TFUNCTION) then
      raise Exception.CreateFmt('֐ %s ܂', [FuncName]);
    lua_pushstring(L, PChar(RE));
    lua_pushstring(L, PChar(edtFileName.Text));
    LuaPCall(L, 2, NResult, 0);
    LuaStackToStrings(L, S);
    memLog.Lines.Add(S.Text);
  finally
    lua_close(L);
    S.Free;
  end;
end;

procedure TfrmMain.btnMatchClick(Sender: TObject);
begin
  Execute('Match', edtMatch.Text, 1);
end;

procedure TfrmMain.btnSubstClick(Sender: TObject);
begin
  Execute('Subst', edtSubst.Text, 0);
end;

procedure TfrmMain.btnSplitClick(Sender: TObject);
begin
  Execute('Split', edtSplit.Text, 0);
end;

procedure TfrmMain.btnTransClick(Sender: TObject);
begin
  Execute('Trans', edtTrans.Text, 0);
end;

end.
