(*
** Tv\zp̕⏕Cu for Delphi
** See Copyright Notice in lua.h
*)
unit LuaBRegExp;

interface

uses
  SysUtils, lua, lualib, lauxlib, LuaUtils, BRegExp;

type
  TLuaBRegExpNames = record
    ClassString: string;
    HandleString: string;
    CreateString: string;
    MatchString: string;
    SubstString: string;
    SplitString: string;
    TransString: string;
    LastCommandString: string;
    MatchPosString: string;
    MatchLengthString: string;
    CountString: string;
    StringsString: string;
  end;

procedure LuaBRegExpRegister(L: Plua_State; FirstIndex: Integer = 0);
procedure LuaBRegExpGetNames(var LuaBRegExpNames: TLuaBRegExpNames);
procedure LuaBRegExpSetNames(const LuaBRegExpNames: TLuaBRegExpNames);

implementation

type
  TCustomBRegExp = class(TBRegExp)
    TargetString: string;
  end;
  PCustomBRegExp = ^TCustomBRegExp;
  TRegExp = TCustomBRegExp;
  PRegExp = PCustomBRegExp;

var
  Names: TLuaBRegExpNames;
  FirstIndex: Integer;

function RE(L: PLua_State): TRegExp;
begin
  LuaGetTable(L, 1, Names.HandleString);
  Result := PRegExp(lua_touserdata(L, -1))^;
end;

function LuaBRegExpMatch(L: PLua_State): Integer; cdecl;
begin
  with (RE(L)) do
  try
    TargetString := luaL_checkstring(L, 3);
    LuaPushBoolean(L, Match(luaL_checkstring(L, 2), TargetString));
  except
    on E: Exception do luaL_error(L, PChar(E.Message));
  end;
  Result := 1;
end;

function LuaBRegExpSubst(L: PLua_State): Integer; cdecl;
var
  B: Boolean;
begin
  with (RE(L)) do
  try
    TargetString := luaL_checkstring(L, 3);
    B := Subst(luaL_checkstring(L, 2), TargetString);
    lua_pushstring(L, PChar(TargetString));
    LuaPushBoolean(L, B);
  except
    on E: Exception do luaL_error(L, PChar(E.Message));
  end;
  Result := 2;
end;

function LuaBRegExpSplit(L: PLua_State): Integer; cdecl;
begin
  with (RE(L)) do
  try
    TargetString := luaL_checkstring(L, 3);
    LuaPushBoolean(L, Split(luaL_checkstring(L, 2), TargetString, luaL_checkint(L, 4)));
  except
    on E: Exception do luaL_error(L, PChar(E.Message));
  end;
  Result := 1;
end;

function LuaBRegExpTrans(L: PLua_State): Integer; cdecl;
var
  B: Boolean;
begin
  with (RE(L)) do
  try
    TargetString := luaL_checkstring(L, 3);
    B := Trans(luaL_checkstring(L, 2), TargetString);
    lua_pushstring(L, PChar(TargetString));
    LuaPushBoolean(L, B);
  except
    on E: Exception do luaL_error(L, PChar(E.Message));
  end;
  Result := 2;
end;

function LuaBRegExpGet(L: PLua_State): Integer; cdecl;
  procedure Strings(Index: Integer);
  var
    S: string;
  begin
    S := RE(L).Strings[luaL_checkint(L, Index) - FirstIndex];
    lua_pushstring(L, PChar(S));
  end;
var
  Name: string;
begin
  Result := 1;
  try
    if (lua_type(L, 2) = LUA_TNUMBER) then
    begin
      Strings(2);
      Exit;
    end;
    Name := luaL_checkstring(L, 2);
    if (Name = Names.LastCommandString) then lua_pushstring(L, PChar(RE(L).LastCommand))
    else if (Name = Names.MatchPosString) then lua_pushnumber(L, RE(L).MatchPos)
    else if (Name = Names.MatchLengthString) then lua_pushnumber(L, RE(L).MatchLength)
    else if (Name = Names.CountString) then lua_pushnumber(L, RE(L).Count)
    else if (Name = Names.StringsString) then Strings(3);
  except
    on E: Exception do luaL_error(L, PChar(E.Message));
  end;
end;

function LuaBRegExpDestroy(L: PLua_State): Integer; cdecl;
begin
  try
    PRegExp(lua_touserdata(L, -1))^.Free;
  except
    on E: Exception do luaL_error(L, PChar(E.Message));
  end;
  Result := 0;
end;

function LuaBRegExpCreate(L: PLua_State): Integer; cdecl;
var
  P: PRegExp;
begin
  lua_newtable(L);
  P := lua_newuserdata(L, SizeOf(PRegExp));
  P^ := TRegExp.Create;
  LuaSetMetaFunction(L, -1, '__gc', LuaBRegExpDestroy);
  LuaSetTableValue(L, 1, Names.HandleString, -1);
  LuaSetTableFunction(L, 1, Names.MatchString, LuaBRegExpMatch);
  LuaSetTableFunction(L, 1, Names.SubstString, LuaBRegExpSubst);
  LuaSetTableFunction(L, 1, Names.SplitString, LuaBRegExpSplit);
  LuaSetTableFunction(L, 1, Names.TransString, LuaBRegExpTrans);
  LuaSetMetaFunction(L, 1, '__index', LuaBRegExpGet);
  lua_pop(L, 1);
  Result := 1;
end;

procedure LuaBRegExpGetNames(var LuaBRegExpNames: TLuaBRegExpNames);
begin
  LuaBRegExpNames := Names;
end;

procedure LuaBRegExpSetNames(const LuaBRegExpNames: TLuaBRegExpNames);
// ֐̕ύX
// XbhZ[tł͂Ȃ
begin
  Names := LuaBRegExpNames;
end;

procedure LuaBRegExpRegister(L: Plua_State; FirstIndex: Integer);
var
  S: string;
begin
  LuaBRegExp.FirstIndex := FirstIndex;
  S := Names.ClassString;
  if (Names.CreateString <> '') then
    S := S + '.' + Names.CreateString;
  LuaRegister(L, PChar(S), LuaBRegExpCreate);
end;

initialization
  Names.ClassString := 'bregexp';
  Names.HandleString := 'handle';
  Names.CreateString := 'create';
  Names.MatchString := 'match';
  Names.SubstString := 'subst';
  Names.SplitString := 'split';
  Names.TransString := 'trans';
  Names.LastCommandString := 'lastcommand';
  Names.MatchPosString := 'matchpos';
  Names.MatchLengthString := 'matchlength';
  Names.CountString := 'count';
  Names.StringsString := 'string';

end.
